<?php
/**
 * @category Mageants SimpleConfigurable
 * @package Mageants_SimpleConfigurable
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants Team <info@mageants.com>
 */

namespace Mageants\SimpleConfigurable\Plugin\Checkout;

use Magento\Checkout\Model\Cart\ImageProvider as OriginalImageProvider;
use Magento\Quote\Api\CartItemRepositoryInterface;
use Magento\Quote\Model\Quote\Item;
use Mageants\SimpleConfigurable\Helper\Data as SCPHelper;
use Magento\Catalog\Helper\Image;
use Magento\Catalog\Model\Product\Configuration\Item\ItemResolverInterface;

class OverrideImageProvider
{
    /**
     * @var CartItemRepositoryInterface
     */
    protected $itemRepository;

    /**
     * @var SCPHelper
     */
    protected $scpHelper;

    /**
     * @var Image
     */
    private $imageHelper;

    /**
     * @var ItemResolverInterface
     */
    private $itemResolver;

    /**
     * Constructor
     *
     * @param CartItemRepositoryInterface $itemRepository
     * @param SCPHelper $scpHelper
     * @param Image $imageHelper
     * @param ItemResolverInterface $itemResolver
     */
    public function __construct(
        CartItemRepositoryInterface $itemRepository,
        SCPHelper $scpHelper,
        Image $imageHelper,
        ItemResolverInterface $itemResolver
    ) {
        $this->itemRepository = $itemRepository;
        $this->scpHelper = $scpHelper;
        $this->imageHelper = $imageHelper;
        $this->itemResolver = $itemResolver;
    }

    /**
     * Before plugin for getImages
     *
     * @param ImageProvider $subject
     * @param int $cartId
     * @return array
     */
    public function aroundGetImages(OriginalImageProvider $subject, callable $proceed, $cartId)
    {
        try {
            $isEnable = ($this->scpHelper->isEnable() && $this->scpHelper->updateChieldInCart());

            if ($isEnable) {
                $itemData = [];
                /** @see code/Magento/Catalog/Helper/Product.php */
                $items = $this->itemRepository->getList($cartId);
                /** @var \Magento\Quote\Model\Quote\Item $cartItem */
                foreach ($items as $cartItem) {
                    $newCartItem = $cartItem;
                    if ($cartItem->getHasChildren() && $cartItem->getProductType() === \Magento\ConfigurableProduct\Model\Product\Type\Configurable::TYPE_CODE) {
                        foreach ($cartItem->getChildren() as $child) {
                            $newCartItem = $child;
                            break;
                        }
                    }
                    $itemData[$cartItem->getItemId()] = $this->getProductImageData($newCartItem);
                }
                return $itemData;
            }
            return $proceed($cartId);

        } catch (\Exception $e) {
            return $proceed($cartId);
        }
    }

    /**
     * Get product image data
     *
     * @param \Magento\Quote\Model\Quote\Item $cartItem
     *
     * @return array
     */
    private function getProductImageData($cartItem)
    {
        $imageHelper = $this->imageHelper->init(
            $this->itemResolver->getFinalProduct($cartItem),
            'mini_cart_product_thumbnail'
        );
        $imageData = [
            'src' => $imageHelper->getUrl(),
            'alt' => $imageHelper->getLabel(),
            'width' => $imageHelper->getWidth(),
            'height' => $imageHelper->getHeight(),
        ];
        return $imageData;
    }
}
