<?php
/**
 * @category Mageants SimpleConfigurable
 * @package Mageants_SimpleConfigurable
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants Team <info@mageants.com>
 */

namespace Mageants\SimpleConfigurable\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;

class Data extends AbstractHelper
{
    public const SIMPLE_CONFIGURABLE_ENABLE = 'simpleconfigurable_config/simpleconfigurable_settings/enable';

    public const PRESELECT_STATUS = 'simpleconfigurable_config/simpleconfigurable_settings/preselect';

    public const SHOW_SWATCHES_PER_PRODUCT = "catalog/frontend/swatches_per_product";

    public const SIMPLE_CONFIGURABLE_RELOAD_CONTENT = "simpleconfigurable_config/simpleconfigurable_reload/content";

    public const SIMPLE_CONFIGURABLE_UPDATE_META = "simpleconfigurable_config/simpleconfigurable_settings/updatemeta";

    public const SIMPLE_CONFIGURABLE_UPDATE_URL = "simpleconfigurable_config/simpleconfigurable_settings/updatepageurl";

    public const SIMPLE_CONFIGURABLE_SHOW_QTY = "simpleconfigurable_config/simpleconfigurable_settings/showqty";

    public const SIMPLE_CONFIGURABLE_UPDATE_BREADCRUMBS = "simpleconfigurable_config/simpleconfigurable_settings/updatebreadcrumbs";

    public const SIMPLE_CONFIGURABLE_UPDATE_UPDATECHIELDINCART = "simpleconfigurable_config/simpleconfigurable_settings/updatechieldincart";

    public const SIMPLE_CONFIGURABLE_UPDATE_UPDATECHIELDINORDER = "simpleconfigurable_config/simpleconfigurable_settings/updatechieldinorder";

    public const GENERATE_CONFIGURABLE_CHILD_PRODUCT_URLS_IN_SITEMAP = "simpleconfigurable_config/simpleconfigurable_settings/showchildurl";

    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @param ScopeConfigInterface $scopeConfig
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        ScopeConfigInterface $scopeConfig,
        StoreManagerInterface $storeManager
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->storeManager = $storeManager;
    }

    /**
     * Get store config value
     *
     * @param string $field
     * @param int|null $storeId
     * @return string
     */
    public function getConfigValue($field, $storeId = null)
    {
        return $this->scopeConfig->getValue(
            $field,
            ScopeInterface::SCOPE_STORE,
            $storeId
        );
    }

    /**
     * Check is enable
     *
     * @param int|null $storeId
     * @return string
     */
    public function isEnable($storeId = null)
    {
        return $this->getConfigValue(self::SIMPLE_CONFIGURABLE_ENABLE, $storeId);
    }

    /**
     * Get preselect source
     *
     * @param int|null $storeId
     * @return string
     */
    public function getPreselectSource($storeId = null)
    {
        return $this->getConfigValue(self::PRESELECT_STATUS, $storeId);
    }

    /**
     * Get number of swatches from config to show on product listing.
     *
     * Other swatches can be shown after click button 'Show more'
     *
     * @param int|null $storeId
     * @return string
     */
    public function getNumberSwatchesPerProduct($storeId = null)
    {
        return $this->getConfigValue(self::SHOW_SWATCHES_PER_PRODUCT, $storeId);
    }

    /**
     * Get reload content
     *
     * @param int|null $storeId
     * @return string
     */
    public function getReloadContent($storeId = null)
    {
        return $this->getConfigValue(self::SIMPLE_CONFIGURABLE_RELOAD_CONTENT, $storeId);
    }

    /**
     * Update metadata of product
     *
     * @param int|null $storeId
     * @return string
     */
    public function updateMetaDta($storeId = null)
    {
        return $this->getConfigValue(self::SIMPLE_CONFIGURABLE_UPDATE_META, $storeId);
    }

    /**
     * Replace URL
     *
     * @param int|null $storeId
     * @return string
     */
    public function replaceUrl($storeId = null)
    {
        return $this->getConfigValue(self::SIMPLE_CONFIGURABLE_UPDATE_URL, $storeId);
    }

    /**
     * Show qty status
     *
     * @param int|null $storeId
     * @return string
     */
    public function showQtyEnable($storeId = null)
    {
        return $this->getConfigValue(self::SIMPLE_CONFIGURABLE_SHOW_QTY, $storeId);
    }

    /**
     * Update metadata of product
     *
     * @param int|null $storeId
     * @return string
     */
    public function replaceBreadCrumbsData($storeId = null)
    {
        return $this->getConfigValue(self::SIMPLE_CONFIGURABLE_UPDATE_BREADCRUMBS, $storeId);
    }

    /**
     * Update Chield In Cart
     *
     * @param int|null $storeId
     * @return string
     */
    public function updateChieldInCart($storeId = null)
    {
        return $this->getConfigValue(self::SIMPLE_CONFIGURABLE_UPDATE_UPDATECHIELDINCART, $storeId);
    }

    /**
     * Update Chield In Order
     *
     * @param int|null $storeId
     * @return string
     */
    public function updateChieldInOrder($storeId = null)
    {
        return $this->getConfigValue(self::SIMPLE_CONFIGURABLE_UPDATE_UPDATECHIELDINORDER, $storeId);
    }

    /**
     * Update child product url in sitemap
     *
     * @param int|null $storeId
     * @return string
     */
    public function generateChildUrls($storeId = null)
    {
        return $this->getConfigValue(self::GENERATE_CONFIGURABLE_CHILD_PRODUCT_URLS_IN_SITEMAP, $storeId);
    }

    /**
     * Get full product URL by appending URL suffix if set
     *
     * @param object $product
     * @return string
     */
    public function getProductFullUrlByProduct($product)
    {
        $suffixValue = $this->getConfigValue(\Magento\CatalogUrlRewrite\Model\ProductUrlPathGenerator::XML_PATH_PRODUCT_URL_SUFFIX);

        $urlKey = $product->getUrlKey();
        $baseUrl = $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_LINK);

        if (!empty($suffixValue)) {
            return $baseUrl . $urlKey . $suffixValue;
        }

        return $baseUrl . $urlKey;
    }
}
