<?php
namespace Mageants\SimpleConfigurable\Block\System\Config;

class Import extends \Magento\Config\Block\System\Config\Form\Field
{
    protected $_template = 'Mageants_SimpleConfigurable::system/config/import.phtml';

    protected $formKey;

    protected $_storeManager;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Data\Form\FormKey $formKey,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        array $data = []
    ) {
        $this->formKey = $formKey;
        $this->_storeManager = $storeManager;
        parent::__construct($context, $data);
    }

    /**
     * get form key
     *
     * @return string
     */
    public function getFormKey()
    {
         return $this->formKey->getFormKey();
    }
 
    public function render(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();
        return parent::render($element);
    }
       protected function _getElementHtml(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        return $this->_toHtml();
    }
    public function getAjaxUrl()
    {
        return $this->getUrl('confpreselect/system_config/import');
    }
    public function getButtonHtml()
    {
        $button = $this->getLayout()->createBlock(
            'Magento\Backend\Block\Widget\Button'
        )->setData(
            [
                'id' => 'importbtn',
                'label' => __('Import'),
                'type' => 'submit',
            ]
        );
 
        return $button->toHtml();
    }

    public function getExampleCsvPath(){
        return $this->getUrl('confpreselect/export/download');
        $mediaUrl = $this->_storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
        return $mediaUrl."scppreselectcsv/scppreselectimport.csv";
    }
}